<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// مسیر دایرکتوری برای بررسی فایل‌ها
$scanDirectory = "/home/backlinkyek";


$dangerousFunctions = [
    "system", "exec", "passthru", "shell_exec", "eval", "popen", "proc_open", "base64_decode", "curl_exec"
];


$startDate = strtotime("2025-09-25");
$currentDate = time();


function checkFileForShell($filePath) {
    global $dangerousFunctions, $startDate, $currentDate;

    
    $fileExtension = pathinfo($filePath, PATHINFO_EXTENSION);
    if (strtolower($fileExtension) !== "php") {
        return false; // فقط فایل‌های PHP
    }

    
    $lastModifiedTime = filemtime($filePath);

    
    if ($lastModifiedTime >= $startDate && $lastModifiedTime <= $currentDate) {
       
        $content = file_get_contents($filePath);
        foreach ($dangerousFunctions as $function) {
            if (strpos($content, $function) !== false) {
                return true;
            }
        }
    }

    return false;
}


function scanDirectory($directory) {
    $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));
    $suspiciousFiles = [];

    foreach ($files as $file) {
        
        if ($file->isFile() && checkFileForShell($file)) {
            $suspiciousFiles[] = $file->getRealPath();
        }
    }

    return $suspiciousFiles;
}


$suspiciousFiles = scanDirectory($scanDirectory);
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لئو ابزار شناسایی Webshell</title>
    <link href="https://fonts.googleapis.com/css2?family=Vazir&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Vazir', sans-serif;
            background-color: #212121;
            color: #fff;
            margin: 0;
            padding: 0;
        }

        header {
            background-color: #E53935;
            color: #fff;
            padding: 20px;
            text-align: center;
            font-size: 28px;
            font-weight: bold;
        }

        .container {
            width: 80%;
            margin: 40px auto;
            padding: 20px;
            background-color: #333;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            border-radius: 10px;
        }

        .btn {
            display: inline-block;
            padding: 15px 25px;
            background-color: #E53935;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        .btn:hover {
            background-color: #c62828;
        }

        .output {
            background-color: #555;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
        }

        .file-list {
            margin-top: 20px;
            padding: 10px;
        }

        .file-list input {
            margin-right: 10px;
            margin-bottom: 15px;
        }

        .file-list div {
            font-size: 16px;
            padding: 8px;
            background-color: #444;
            margin: 5px 0;
            border-radius: 5px;
        }

        .file-list p {
            font-size: 18px;
        }
    </style>
</head>
<body>

<header>
   لئو شناسایی و حذف Webshell
</header>

<div class="container">
    <h2>فایل‌های PHP که از 25 سپتامبر تا امروز تغییر کرده‌اند:</h2>

    <form method="post">
        <div class="file-list">
            <?php
            if (count($suspiciousFiles) > 0) {
                foreach ($suspiciousFiles as $file) {
                    echo "<div><input type='checkbox' name='filesToDelete[]' value='$file'> $file</div>";
                }
            } else {
                echo "<p>هیچ فایل PHP که از 25 سپتامبر تا امروز تغییر کرده باشد، شناسایی نشد.</p>";
            }
            ?>
        </div>

        <button type="submit" name="delete" class="btn">حذف فایل‌های انتخاب‌شده</button>
    </form>

    <div class="output">
        <?php
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete']) && isset($_POST['filesToDelete'])) {
            $filesToDelete = $_POST['filesToDelete'];
            foreach ($filesToDelete as $file) {
                if (unlink($file)) {
                    echo "<p>فایل حذف شد: $file</p>";
                } else {
                    echo "<p>حذف فایل ناموفق: $file</p>";
                }
            }
        }
        ?>
    </div>
</div>

</body>
</html>
